import type { LocaleObject } from 'yup';

export const plYupLocale: LocaleObject = {
  array: {
    length: '${path} must have ${length} items',
    max: '${path} field must have less than or equal to ${max} items',
    min: '${path} field must have at least ${min} items'
  },
  boolean: {
    isValue: '${path} field must be ${value}'
  },
  date: {
    max: '${path} field must be at earlier than ${max}',
    min: '${path} field must be later than ${min}'
  },
  mixed: {
    default: '${path} is invalid',
    defined: '${path} must be defined',
    notNull: '${path} cannot be null',
    notOneOf: '${path} must not be one of the following values: ${values}',
    notType: '${path} must be a valid type',
    oneOf: '${path} must be one of the following values: ${values}',
    required: '${path} is a required field'
  },
  number: {
    integer: '${path} must be an integer',
    lessThan: '${path} must be less than ${less}',
    max: '${path} must be less than or equal to ${max}',
    min: '${path} must be greater than or equal to ${min}',
    moreThan: '${path} must be greater than ${more}',
    negative: '${path} must be a negative number',
    positive: '${path} must be a positive number'
  },
  object: {
    exact: '${path} object contains unknown properties: ${properties}',
    noUnknown: '${path} field has unspecified keys: ${unknown}'
  },
  string: {
    datetime: '${path} must be a valid ISO date-time',
    datetime_offset: '${path} must be a valid ISO date-time with UTC "Z" timezone',
    datetime_precision: '${path} must be a valid ISO date-time with a sub-second precision of exactly ${precision} digits',
    email: '${path} must be a valid email',
    length: '${path} must be exactly ${length} characters',
    lowercase: '${path} must be a lowercase string',
    matches: '${path} must match the following: "${regex}"',
    max: '${path} must be at most ${max} characters',
    min: '${path} must be at least ${min} characters',
    trim: '${path} must be a trimmed string',
    uppercase: '${path} must be a upper case string',
    url: '${path} must be a valid URL',
    uuid: '${path} must be a valid UUID'
  },
  tuple: {
    notType: '${path} must be a valid tuple type'
  }
};

/*eslint sort-keys: ["error", "asc", {caseSensitive: false}]*/
export const plTranslations = {
  accountSettingsTitle: 'Account Settings',
  accountTitle: 'Account',
  accountTypeTitle: 'Account Type',
  addFormat: 'Add Format',
  addMeeting: 'Add Meeting',
  addServiceBody: 'Add Service Body',
  addUser: 'Add User',
  administrationTitle: 'Administration',
  administratorTitle: 'Administrator',
  adminTitle: 'Admin',
  anteMeridiem: 'AM',
  applyChangesTitle: 'Apply Changes',
  automaticallyCalculatedOnSave: 'Automatically calculated on save',
  boroughTitle: 'Borough/City Subsection',
  busLinesTitle: 'Bus Lines',
  by: 'by',
  cancel: 'Cancel',
  chooseStartTime: 'Choose start time',
  cityTownTitle: 'City/Town',
  clearFormTitle: 'Clear Form',
  close: 'Zamknij',
  closeWithoutSaving: 'Close without saving',
  commentsTitle: 'Comments',
  confirmDeleteFormat: 'Are you sure you want to delete this format?',
  confirmDeleteMeeting: 'Are you sure you want to delete this meeting?',
  confirmDeleteServiceBody: 'Are you sure you want to delete this service body?',
  confirmDeleteUser: 'Are you sure you want to delete this user?',
  confirmYesImSure: "Yes, I'm sure.",
  contact1EmailTitle: 'Contact 1 Email',
  contact1NameTitle: 'Contact 1 Name',
  contact1PhoneTitle: 'Contact 1 Phone',
  contact2EmailTitle: 'Contact 2 Email',
  contact2NameTitle: 'Contact 2 Name',
  contact2PhoneTitle: 'Contact 2 Phone',
  copyToClipboard: 'Skopiuj do schowka',
  countySubProvinceTitle: 'County/Sub-Province',
  dashboardTitle: 'Dashboard',
  day: 'Day',
  day0: 'Sunday',
  day1: 'Monday',
  day2: 'Tuesday',
  day3: 'Wednesday',
  day4: 'Thursday',
  day5: 'Friday',
  day6: 'Saturday',
  dayTitle: 'Weekday',
  deactivatedTitle: 'Deactivated',
  deactivatedUserTitle: 'Deactivated User',
  delete: 'Delete',
  deleteFormat: 'Delete Format',
  deleteMeeting: 'Delete Meeting',
  deleteServiceBody: 'Delete Service Body',
  deleteUser: 'Delete User',
  descriptionTitle: 'Description',
  details: 'Details (row number or meeting ID)',
  downloading: 'Downloading...',
  downloadLaravelLog: 'Download Laravel Log',
  downloadTranslationsForCurrentLanguage: 'Download translations for the language selected at login',
  downloadTranslationsSpreadsheet: 'Download Translations Spreadsheet',
  durationTitle: 'Duration',
  editFormat: 'Edit Format',
  editUser: 'Edit User',
  emailTitle: 'Email',
  error: 'Error',
  errorDownloading: 'Error Downloading',
  errors: 'Errors',
  extraInfoTitle: 'Extra Info',
  fileProcessedSuccessfully: '✓ File Processed Successfully',
  filter: 'Filter',
  formatDeleteConflictError: 'Error: The format could not be deleted because it is still associated with meetings.',
  formatId: 'Format ID',
  formatsTitle: 'Formats',
  formatTranslationIsRequired: 'a translation is required for all languages for reserved formats',
  formatTypeCode_ALERT: 'Format should be especially prominent (Clean requirement, etc.)',
  formatTypeCode_COMMON_NEEDS_OR_RESTRICTION: 'Common Needs and Restrictions (Mens Meeting, LGTBQ, No Children, etc.)',
  formatTypeCode_LANGUAGE: 'Language',
  formatTypeCode_LOCATION: 'Location Code (Wheelchair Accessible, Limited Parking, etc.)',
  formatTypeCode_MEETING_FORMAT: 'Meeting Format (Speaker, Book Study, etc.)',
  formatTypeCode_NONE: 'None',
  formatTypeCode_OPEN_OR_CLOSED: 'Attendance by non-addicts (Open, Closed)',
  formatTypeTitle: 'Format Type',
  formatValidationError: 'Error: This format is protected and cannot be deleted.',
  geocodingFailed: 'Geocoding failed',
  googleGeocodingFailed: 'Google geocoding failed',
  googleKeyProblemDescription: 'The Google Maps API key is invalid or not properly configured. Please update your API key settings.',
  googleKeyProblemTitle: 'Google Maps API Key Problem',
  helplineTitle: 'Helpline',
  hideDetails: 'Ukryj szczegóły',
  homeTitle: 'Home',
  hoursTitle: 'Hours',
  idTitle: 'ID',
  invalidUsernameOrPassword: 'Invalid username or password.',
  keyIsRequired: 'key is required',
  keyIsReserved: 'key is reserved  -- please use something else',
  keyTitle: 'Key',
  languageSelectTitle: 'Select Language',
  lastLoginTitle: 'Last Login',
  latitudeTitle: 'Latitude',
  loadFile: 'Load file',
  loading: 'loading ...',
  locationMapTitle: 'Location Map', // TOFIX: translate
  locationStreetErrorMessage: 'Hybrid or In-person meetings must have a street address.',
  locationTextTitle: 'Location Text',
  loginTitle: 'Login',
  loginVerb: 'Log In',
  logout: 'Logout',
  longitudeTitle: 'Longitude',
  malformedRows: 'Malformed rows',
  meeting: 'meeting',
  meetingErrorsSomewhere: 'Tabs with one or more errors:',
  meetingIsPublishedTitle: 'Meeting is Published',
  meetingListEditorsTitle: 'Meeting List Editors',
  meetings: 'meetings',
  meetingsPerPage: 'Meetings per page',
  meetingsTitle: 'Meetings',
  meetingUnpublishedNote: 'Note: Unpublishing a meeting indicates a temporary closure. If this meeting has closed permanently, please delete it.',
  minutesTitle: 'Minutes',
  nameTitle: 'Name',
  nationTitle: 'Nation',
  nawsFormat_BEG: 'Beginner/Newcomer',
  nawsFormat_BT: 'Basic Text',
  nawsFormat_CAN: 'Candlelight',
  nawsFormat_CH: 'Closed Holidays',
  nawsFormat_CLOSED: 'Closed',
  nawsFormat_CPT: '12 Concepts',
  nawsFormat_CW: 'Children Welcome',
  nawsFormat_DISC: 'Discussion/Participation',
  nawsFormat_GL: 'Gay/Lesbian',
  nawsFormat_GP: 'Guiding Principles',
  nawsFormat_HYBR: 'Virtual and In-Person',
  nawsFormat_IP: 'IP Study',
  nawsFormat_IW: 'It Works Study',
  nawsFormat_JFT: 'Just For Today Study',
  nawsFormat_LANG: 'Alternate Language',
  nawsFormat_LC: 'Living Clean',
  nawsFormat_LIT: 'Literature Study',
  nawsFormat_M: 'Men',
  nawsFormat_MED: 'Meditation',
  nawsFormat_NC: 'No Children',
  nawsFormat_NONE: 'None',
  nawsFormat_NS: 'Non-Smoking',
  nawsFormat_OPEN: 'Open',
  nawsFormat_QA: 'Questions & Answers',
  nawsFormat_RA: 'Restricted Access',
  nawsFormat_SD: 'Speaker/Discussion',
  nawsFormat_SMOK: 'Smoking',
  nawsFormat_SPAD: 'Spiritual Principle a Day',
  nawsFormat_SPK: 'Speaker',
  nawsFormat_STEP: 'Step',
  nawsFormat_SWG: 'Step Working Guide Study',
  nawsFormat_TC: 'Temporarily Closed Facility',
  nawsFormat_TOP: 'Topic',
  nawsFormat_TRAD: 'Tradition',
  nawsFormat_VAR: 'Format Varies',
  nawsFormat_VM: 'Virtual',
  nawsFormat_W: 'Women',
  nawsFormat_WCHR: 'Wheelchair-Accessible',
  nawsFormat_Y: 'Young People',
  nawsFormatTitle: 'NAWS Format',
  neighborhoodTitle: 'Neighborhood',
  noChangesFound: 'No changes found',
  noFormatTranslationsError: 'At least one translation is required.',
  noLogsFound: 'No logs found',
  nominatimGeocodingFailed: 'Nominatim geocoding failed: no results found',
  none: '- None -',
  noServiceBodiesTitle: 'No service bodies found that this user can edit',
  notedAsDeleted: 'Noted as deleted',
  notFound: 'Not found',
  noTranslationAvailable: 'no translation available',
  noUpdateNeeded: 'No update needed',
  noUsersTitle: 'No other users found that this user can edit',
  noWhitespaceInKey: 'Whitespace not allowed in key',
  observerTitle: 'Service Body Observer',
  occurredAt: 'Wystąpiło o',
  ownedByTitle: 'Owned By',
  paginationOf: 'of',
  paginationShowing: 'Showing',
  parentIdTitle: 'Service Body Parent',
  passwordTitle: 'Password',
  phoneMeetingTitle: 'Phone Meeting Dial-in Number',
  postMeridiem: 'PM',
  processingFile: 'Processing file...',
  published: 'Published',
  saveAsCopy: 'Zapisz jako kopię',
  saveAsCopyCheckbox: 'Zapisz to spotkanie jako kopię (Tworzy nowe spotkanie)',
  saveAsNewMeeting: 'Zapisz jako nowe spotkanie',
  saving: 'Zapisywanie...',
  search: 'Search',
  searchByDay: 'Search by day',
  searchByName: 'Search by name',
  searchByServiceBody: 'Search by Service Body',
  searchMeetings: 'Search meetings...',
  selectAllDays: 'Select All Days',
  selectAllServiceBodies: 'Select All Service Bodies',
  serverAdministratorTitle: 'Main Server Administrator',
  serverTitle: 'BMLT Server',
  serviceBodiesNoParent: 'No Parent (Top-Level)',
  serviceBodiesTitle: 'Service Bodies',
  serviceBodiesWithEditableMeetings: 'This user can edit meetings in these service bodies:',
  serviceBodyAdminTitle: 'Service Body Administrator',
  serviceBodyDeleteConflictError: 'Error: The service body could not be deleted because it is still associated with meetings or is a parent of other service bodies.',
  serviceBodyInvalid: 'Please select a valid service body',
  serviceBodyTitle: 'Service Body',
  serviceBodyTypeTitle: 'Service Body Type',
  showAllTranslations: 'Show all translations',
  showDetails: 'Pokaż szczegóły',
  startTimeTitle: 'Start Time',
  stateTitle: 'State/Province',
  streetTitle: 'Street',
  summary: 'Summary',
  supportedFileFormats: 'Supported formats: Excel (.xlsx) and CSV (.csv)',
  tabsBasic: 'Basic',
  tabsChanges: 'Changes',
  tabsLocation: 'Location',
  tabsOther: 'Other',
  technicalDetails: 'Szczegóły techniczne',
  time: 'Time',
  timeAfternoon: 'Afternoon',
  timeEvening: 'Evening',
  timeMorning: 'Morning',
  timeZoneGeocodeError: 'Unable to determine timezone from coordinates. Please select a timezone manually',
  timeZoneInvalid: 'Invalid time zone',
  timeZoneSelectPlaceholder: 'Choose option (or leave blank to auto-detect from location)',
  timeZoneTitle: 'Time Zone',
  totalRows: 'Total rows (excluding header)',
  trainLinesTitle: 'Train Lines',
  unpublished: 'Unpublished',
  unselectAllDays: 'Unselect All Days',
  unselectAllServiceBodies: 'Unselect All Service Bodies',
  updated: 'Updated',
  updateWorldCommitteeCodes: 'Update World Committee Codes',
  userDeleteConflictError: 'Error: The user could not be deleted because it is still associated with at least one service body or is the parent of another user.',
  userIsDeactivated: 'User is deactivated.',
  usernameTitle: 'Username',
  usersTitle: 'Users',
  userTitle: 'User',
  userTypeTitle: 'User Type',
  venueTypeTitle: 'Venue Type',
  virtualMeetingAdditionalInfoTitle: 'Virtual Meeting Additional Information',
  virtualMeetingTitle: 'Virtual Meeting Link',
  websiteUrlTitle: 'Web Site URL',
  welcome: 'Welcome',
  worldIdTitle: 'World Committee Code',
  youHaveUnsavedChanges: 'You have unsaved changes. Do you really want to close?',
  zipCodeTitle: 'Zip Code/Postal Code'
};
