import type { LocaleObject } from 'yup';

export const itYupLocale: LocaleObject = {
  array: {
    length: '${path} must have ${length} items',
    max: '${path} field must have less than or equal to ${max} items',
    min: '${path} field must have at least ${min} items'
  },
  boolean: {
    isValue: '${path} field must be ${value}'
  },
  date: {
    max: '${path} field must be at earlier than ${max}',
    min: '${path} field must be later than ${min}'
  },
  mixed: {
    default: '${path} is invalid',
    defined: '${path} must be defined',
    notNull: '${path} cannot be null',
    notOneOf: '${path} must not be one of the following values: ${values}',
    notType: '${path} must be a valid type',
    oneOf: '${path} must be one of the following values: ${values}',
    required: '${path} is a required field'
  },
  number: {
    integer: '${path} must be an integer',
    lessThan: '${path} must be less than ${less}',
    max: '${path} must be less than or equal to ${max}',
    min: '${path} must be greater than or equal to ${min}',
    moreThan: '${path} must be greater than ${more}',
    negative: '${path} must be a negative number',
    positive: '${path} must be a positive number'
  },
  object: {
    exact: '${path} object contains unknown properties: ${properties}',
    noUnknown: '${path} field has unspecified keys: ${unknown}'
  },
  string: {
    datetime: '${path} must be a valid ISO date-time',
    datetime_offset: '${path} must be a valid ISO date-time with UTC "Z" timezone',
    datetime_precision: '${path} must be a valid ISO date-time with a sub-second precision of exactly ${precision} digits',
    email: '${path} must be a valid email',
    length: '${path} must be exactly ${length} characters',
    lowercase: '${path} must be a lowercase string',
    matches: '${path} must match the following: "${regex}"',
    max: '${path} must be at most ${max} characters',
    min: '${path} must be at least ${min} characters',
    trim: '${path} must be a trimmed string',
    uppercase: '${path} must be a upper case string',
    url: '${path} must be a valid URL',
    uuid: '${path} must be a valid UUID'
  },
  tuple: {
    notType: '${path} must be a valid tuple type'
  }
};

/*eslint sort-keys: ["error", "asc", {caseSensitive: false}]*/
export const itTranslations = {
  accountSettingsTitle: 'Impostazioni account',
  accountTitle: 'Account',
  accountTypeTitle: 'Tipo di Account',
  addFormat: 'Aggiungi formato',
  addMeeting: 'Aggiungi riunione',
  addServiceBody: 'Aggiungi ente di servizio',
  addUser: 'Aggiungi utente',
  administrationTitle: 'Amministrazione',
  administratorTitle: 'Amministratore',
  adminTitle: 'amministratore',
  anteMeridiem: 'AM',
  applyChangesTitle: 'Applica modifiche',
  automaticallyCalculatedOnSave: 'Automatically calculated on save',
  boroughTitle: 'Distretto/Città',
  busLinesTitle: 'Linee di autobus',
  by: 'di',
  cancel: 'Annulla',
  chooseStartTime: "Scegli l'ora di inizio",
  cityTownTitle: 'Città/Comune',
  clearFormTitle: 'Modulo vuoto',
  close: 'Chiudi',
  closeWithoutSaving: 'Chiudi senza salvare',
  commentsTitle: 'Commenti',
  confirmDeleteFormat: 'Sei sicuro di voler eliminare questo formato?',
  confirmDeleteMeeting: 'Sei sicuro di voler eliminare questa riunione?',
  confirmDeleteServiceBody: 'Sei sicuro di voler eliminare questo ente di servizio?',
  confirmDeleteUser: 'Sei sicuro di voler eliminare questo utente?',
  confirmYesImSure: "Yes, I'm sure.",
  contact1EmailTitle: 'Contatto 1 E-mail',
  contact1NameTitle: 'Contatto 1 Nome',
  contact1PhoneTitle: 'Contatto 1 Telefono',
  contact2EmailTitle: 'Contatto 2 E-mail',
  contact2NameTitle: 'Contatto 2 Nome',
  contact2PhoneTitle: 'Contatto 2 Telefono',
  copyToClipboard: 'Copia negli appunti',
  countySubProvinceTitle: 'Regione',
  dashboardTitle: 'Pannello di controllo',
  day: 'Giorno',
  day0: 'Domenica',
  day1: 'Lunedì',
  day2: 'Martedì',
  day3: 'Mercoledì',
  day4: 'Giovedì',
  day5: 'Venerdì',
  day6: 'Sabato',
  dayTitle: 'Giorno feriale',
  deactivatedTitle: 'Disattivato',
  deactivatedUserTitle: 'Utente disattivato',
  delete: 'Eliminare',
  deleteFormat: 'Elimina formato',
  deleteMeeting: 'Elimina riunione',
  deleteServiceBody: 'Elimina ente di servizio',
  deleteUser: 'Elimina utente',
  descriptionTitle: 'Descrizione',
  details: 'Dettagli (numero di riga o ID riunione)',
  downloading: 'Download in corso..',
  downloadLaravelLog: 'Scarica registro Laravel',
  downloadTranslationsForCurrentLanguage: "Scarica le traduzioni per la lingua selezionata al momento dell'accesso",
  downloadTranslationsSpreadsheet: 'Scarica il foglio di calcolo delle traduzioni',
  durationTitle: 'Durata',
  editFormat: 'Modifica formato',
  editUser: 'Modifica utente',
  emailTitle: 'Email',
  error: 'Errore',
  errorDownloading: 'Errore durante il download',
  errors: 'Errori',
  extraInfoTitle: 'Informazioni aggiuntive',
  fileProcessedSuccessfully: '✓ File elaborato con successo',
  filter: 'Filtro',
  formatDeleteConflictError: 'Errore: impossibile eliminare il formato perché è ancora associato a riunioni.',
  formatId: 'Formato ID',
  formatsTitle: 'Formati',
  formatTranslationIsRequired: 'è richiesta una traduzione per tutte le lingue per i formati riservati',
  formatTypeCode_ALERT: 'Il formato deve essere particolarmente evidente (requisiti di pulizia, ecc.)',
  formatTypeCode_COMMON_NEEDS_OR_RESTRICTION: 'Esigenze comuni e restrizioni (riunioni solo uomini, LGTBQ, niente figli, ecc.)',
  formatTypeCode_LANGUAGE: 'Lingua',
  formatTypeCode_LOCATION: 'Codice posizione (accessibile con sedia a rotelle, parcheggio limitato, ecc.)',
  formatTypeCode_MEETING_FORMAT: 'Formato della riunione (con oratore, studio del libro, ecc.)',
  formatTypeCode_NONE: 'Nessuno',
  formatTypeCode_OPEN_OR_CLOSED: 'Partecipazione di non dipendenti (aperta, chiusa)',
  formatTypeTitle: 'Tipo di formato',
  formatValidationError: 'Errore: questo formato è protetto e non può essere eliminato.',
  geocodingFailed: 'Geocoding failed',
  googleGeocodingFailed: 'Google geocoding failed',
  googleKeyProblemDescription: 'The Google Maps API key is invalid or not properly configured. Please update your API key settings.',
  googleKeyProblemTitle: 'Google Maps API Key Problem',
  helplineTitle: 'Linea di assistenza telefonica',
  hideDetails: 'Nascondi dettagli',
  homeTitle: 'Home',
  hoursTitle: 'Orari',
  idTitle: 'ID',
  invalidUsernameOrPassword: 'Nome utente o password non validi.',
  keyIsRequired: 'è necessaria la chiave',
  keyIsReserved: "La chiave è riservata  -- si prega di utilizzare qualcos'altro",
  keyTitle: 'Chiave',
  languageSelectTitle: 'Seleziona lingua',
  lastLoginTitle: 'Last Login',
  latitudeTitle: 'Latitudine',
  loadFile: 'Carica file',
  loading: 'Caricamento..',
  locationMapTitle: 'Location Map', // TOFIX: translate
  locationStreetErrorMessage: 'Le riunioni ibride o in presenza devono avere un indirizzo postale.',
  locationTextTitle: 'Posizione del testo',
  loginTitle: 'Accedi',
  loginVerb: 'Accesso effettuato',
  logout: 'Esci',
  longitudeTitle: 'Longitudine',
  malformedRows: 'Righe malformate',
  meeting: 'Riunione',
  meetingErrorsSomewhere: 'Schede con uno o più errori:',
  meetingIsPublishedTitle: 'La riunione è pubblicata',
  meetingListEditorsTitle: "Redattori dell'elenco delle riunioni",
  meetings: 'Riunioni',
  meetingsPerPage: 'Riunioni per pagina',
  meetingsTitle: 'Riunioni',
  meetingUnpublishedNote: "Nota: l'annullamento della pubblicazione di una riunione ne indica la chiusura temporanea. Se la riunione è stata chiusa definitivamente, eliminala.",
  minutesTitle: 'Minuti',
  nameTitle: 'Nome',
  nationTitle: 'Nazione',
  nawsFormat_BEG: 'Novizio/Nuovo venuto',
  nawsFormat_BT: 'Testo base',
  nawsFormat_CAN: 'A lume di candela',
  nawsFormat_CH: 'Festività chiuso',
  nawsFormat_CLOSED: 'Chiuso',
  nawsFormat_CPT: '12 Concetti',
  nawsFormat_CW: 'Bambini benvenuti',
  nawsFormat_DISC: 'Discussione/Partecipazione',
  nawsFormat_GL: 'Gay/lesbiche',
  nawsFormat_GP: 'Principi guida',
  nawsFormat_HYBR: 'Virtuale e di persona',
  nawsFormat_IP: 'Studio su IP',
  nawsFormat_IW: 'Studio su Funziona',
  nawsFormat_JFT: 'Studio sul Solo per oggi',
  nawsFormat_LANG: 'Lingua alternativa',
  nawsFormat_LC: 'Vivere puliti',
  nawsFormat_LIT: 'Studio della letteratura',
  nawsFormat_M: 'Uomini',
  nawsFormat_MED: 'Meditazione',
  nawsFormat_NC: 'Niente Bambini',
  nawsFormat_NONE: 'Nessuno',
  nawsFormat_NS: 'Non fumatori',
  nawsFormat_OPEN: 'Aperta',
  nawsFormat_QA: 'Domande e risposte',
  nawsFormat_RA: 'Accesso limitato',
  nawsFormat_SD: 'Oratore/Discussione',
  nawsFormat_SMOK: 'Fumo',
  nawsFormat_SPAD: 'Un Principio Spirituale al giorno',
  nawsFormat_SPK: 'Oratore',
  nawsFormat_STEP: 'Passo',
  nawsFormat_SWG: 'Studio della guida sul lavoro dei passi',
  nawsFormat_TC: 'Struttura temporaneamente chiusa',
  nawsFormat_TOP: 'Argomento',
  nawsFormat_TRAD: 'Tradizione',
  nawsFormat_VAR: 'Formati Vari',
  nawsFormat_VM: 'Virtuale',
  nawsFormat_W: 'Donne',
  nawsFormat_WCHR: 'Accessibile in sedia a rotelle',
  nawsFormat_Y: 'Giovani',
  nawsFormatTitle: 'Formato NAWS',
  neighborhoodTitle: 'Quartiere',
  noChangesFound: 'No changes found',
  noFormatTranslationsError: 'È richiesta almeno una traduzione.',
  noLogsFound: 'Nessun registro trovato',
  nominatimGeocodingFailed: 'Nominatim geocoding failed: no results found',
  none: 'Nessuno',
  noServiceBodiesTitle: 'Nessun ente di servizio trovato che questo utente possa modificare',
  notedAsDeleted: 'Contrassegnato come eliminato',
  notFound: 'Non trovato',
  noTranslationAvailable: 'nessuna traduzione disponibile',
  noUpdateNeeded: 'Non è necessario alcun aggiornamento',
  noUsersTitle: 'Nessun altro utente trovato che questo utente possa modificare',
  noWhitespaceInKey: 'Spazi vuoti non consentiti nella chiave',
  observerTitle: 'Osservatore Organo di Servizio',
  occurredAt: 'Avvenuto alle',
  ownedByTitle: 'Di proprietà di',
  paginationOf: 'di',
  paginationShowing: 'Mostra',
  parentIdTitle: 'Ente di servizo principale',
  passwordTitle: 'Password',
  phoneMeetingTitle: 'Numero da comporre per la riunione telefonica',
  postMeridiem: 'PM',
  processingFile: 'Elaborazione file in corso...',
  published: 'Pubblicato',
  saveAsCopy: 'Salva come copia',
  saveAsCopyCheckbox: 'Salva questa riunione come copia (Crea una nuova riunione)',
  saveAsNewMeeting: 'Salva come nuova riunione',
  saving: 'Salvataggio...',
  search: 'Cerca',
  searchByDay: 'Cerca per giorno',
  searchByName: 'Cerca per nome',
  searchByServiceBody: 'Ricerca per Ente di Servizio',
  searchMeetings: 'Cerca riunioni…',
  selectAllDays: 'Seleziona Tutti i giorni',
  selectAllServiceBodies: 'Seleziona tutti gli enti di servizio',
  serverAdministratorTitle: 'Amministratore server principale',
  serverTitle: 'Server BMLT',
  serviceBodiesNoParent: 'Nessun sottolivello (Livello superiore)',
  serviceBodiesTitle: 'Enti di servizio',
  serviceBodiesWithEditableMeetings: 'Questo utente può modificare le riunioni nei seguenti enti di servizio:',
  serviceBodyAdminTitle: 'Amministratore organismo di servizio',
  serviceBodyDeleteConflictError: "Errore: non è stato possibile eliminare l'organismo di servizio perché è ancora associato a riunioni o è associato ad altri organismi di servizio.",
  serviceBodyInvalid: 'Seleziona un ente di servizio valido',
  serviceBodyTitle: 'Ente di servizio',
  serviceBodyTypeTitle: 'Tipo di corpo di servizio',
  showAllTranslations: 'Mostra tutte le traduzioni',
  showDetails: 'Mostra dettagli',
  startTimeTitle: 'Ora di inizio',
  stateTitle: 'Stato/Provincia',
  streetTitle: 'Via',
  summary: 'Riepilogo',
  supportedFileFormats: 'Formati supportati: Excel (.xlsx) e CSV (.csv)',
  tabsBasic: 'Base',
  tabsChanges: 'Modifiche',
  tabsLocation: 'Posizione',
  tabsOther: 'Altro',
  technicalDetails: 'Dettagli tecnici',
  time: 'Periodo',
  timeAfternoon: 'Pomeriggio',
  timeEvening: 'Sera',
  timeMorning: 'Mattina',
  timeZoneGeocodeError: 'Impossibile determinare il fuso orario dalle coordinate. Seleziona manualmente un fuso orario.',
  timeZoneInvalid: 'Fuso orario non valido',
  timeZoneSelectPlaceholder: "Scegli l'opzione (o lascia vuoto per il rilevamento automatico dalla posizione)",
  timeZoneTitle: 'Fuso orario',
  totalRows: "Righe totali (esclusa l'intestazione)",
  trainLinesTitle: 'Linee ferroviarie',
  unpublished: 'Non pubblicato',
  unselectAllDays: 'Deseleziona tutti i giorni',
  unselectAllServiceBodies: 'Deseleziona tutti gli enti di servizio',
  updated: 'Aggiornato',
  updateWorldCommitteeCodes: 'Aggiorna i codici del Comitato Mondiale',
  userDeleteConflictError: "Errore: l'utente non può essere eliminato perché è ancora associato ad almeno un ente di servizio o è assiociato ad un altro utente.",
  userIsDeactivated: "L'utente è disattivato",
  usernameTitle: 'Nome utente',
  usersTitle: 'Utenti',
  userTitle: 'Utente',
  userTypeTitle: 'Tipo utente',
  venueTypeTitle: 'Tipo di struttura',
  virtualMeetingAdditionalInfoTitle: 'Informazioni aggiuntive riunione virtuale',
  virtualMeetingTitle: 'Collegamento riunione virtuale',
  websiteUrlTitle: 'URL sito web',
  welcome: 'Benvenuto',
  worldIdTitle: 'Codice Comitato Mondiale',
  youHaveUnsavedChanges: 'Ci sono modifiche non salvate. Vuoi davvero chiudere?',
  zipCodeTitle: 'Codice postale/CAP'
};
