import type { LocaleObject } from 'yup';

export const frYupLocale: LocaleObject = {
  array: {
    length: '${path} must have ${length} items',
    max: '${path} field must have less than or equal to ${max} items',
    min: '${path} field must have at least ${min} items'
  },
  boolean: {
    isValue: '${path} field must be ${value}'
  },
  date: {
    max: '${path} field must be at earlier than ${max}',
    min: '${path} field must be later than ${min}'
  },
  mixed: {
    default: '${path} is invalid',
    defined: '${path} must be defined',
    notNull: '${path} cannot be null',
    notOneOf: '${path} must not be one of the following values: ${values}',
    notType: '${path} must be a valid type',
    oneOf: '${path} must be one of the following values: ${values}',
    required: '${path} is a required field'
  },
  number: {
    integer: '${path} must be an integer',
    lessThan: '${path} must be less than ${less}',
    max: '${path} must be less than or equal to ${max}',
    min: '${path} must be greater than or equal to ${min}',
    moreThan: '${path} must be greater than ${more}',
    negative: '${path} must be a negative number',
    positive: '${path} must be a positive number'
  },
  object: {
    exact: '${path} object contains unknown properties: ${properties}',
    noUnknown: '${path} field has unspecified keys: ${unknown}'
  },
  string: {
    datetime: '${path} must be a valid ISO date-time',
    datetime_offset: '${path} must be a valid ISO date-time with UTC "Z" timezone',
    datetime_precision: '${path} must be a valid ISO date-time with a sub-second precision of exactly ${precision} digits',
    email: '${path} must be a valid email',
    length: '${path} must be exactly ${length} characters',
    lowercase: '${path} must be a lowercase string',
    matches: '${path} must match the following: "${regex}"',
    max: '${path} must be at most ${max} characters',
    min: '${path} must be at least ${min} characters',
    trim: '${path} must be a trimmed string',
    uppercase: '${path} must be a upper case string',
    url: '${path} must be a valid URL',
    uuid: '${path} must be a valid UUID'
  },
  tuple: {
    notType: '${path} must be a valid tuple type'
  }
};

/*eslint sort-keys: ["error", "asc", {caseSensitive: false}]*/
export const frTranslations = {
  accountSettingsTitle: 'Paramètres du compte',
  accountTitle: 'Compte',
  accountTypeTitle: 'Type de compte',
  addFormat: 'Ajouter un format',
  addMeeting: 'Ajouter une réunion',
  addServiceBody: 'Ajouter une structure de service',
  addUser: 'Ajouter un utilisateur',
  administrationTitle: 'Administration',
  administratorTitle: 'Administrateur',
  adminTitle: 'Admin',
  anteMeridiem: 'Matin',
  applyChangesTitle: 'Appliquer les modifications',
  automaticallyCalculatedOnSave: 'Automatically calculated on save',
  boroughTitle: 'Arrondissement',
  busLinesTitle: 'Lignes de bus',
  by: 'par',
  cancel: 'Annuler',
  chooseStartTime: "Choisir l'heure de début",
  cityTownTitle: 'Ville',
  clearFormTitle: 'Effacer le formulaire',
  close: 'Fermer',
  closeWithoutSaving: 'Fermer sans sauvegarder',
  commentsTitle: 'Commentaires',
  confirmDeleteFormat: 'Êtes-vous sûr de vouloir supprimer ce format ?',
  confirmDeleteMeeting: 'Êtes-vous sûr de vouloir supprimer cette réunion ?',
  confirmDeleteServiceBody: 'Êtes-vous sûr de vouloir supprimer cette structure de service ?',
  confirmDeleteUser: 'Êtes-vous sûr de vouloir supprimer cet utilisateur ?',
  confirmYesImSure: "Yes, I'm sure.",
  contact1EmailTitle: 'Contact 1 Email',
  contact1NameTitle: 'Contact 1 Nom',
  contact1PhoneTitle: 'Contact 1 Téléphone',
  contact2EmailTitle: 'Contact 2 Email',
  contact2NameTitle: 'Contact 2 Nom',
  contact2PhoneTitle: 'Contact 2 Téléphone',
  copyToClipboard: 'Copier dans le presse-papier',
  countySubProvinceTitle: 'Département',
  dashboardTitle: 'Tableau de bord',
  day: 'Jour',
  day0: 'Dimanche',
  day1: 'Lundi',
  day2: 'Mardi',
  day3: 'Mercredi',
  day4: 'Jeudi',
  day5: 'Vendredi',
  day6: 'Samedi',
  dayTitle: 'Jour de la semaine',
  deactivatedTitle: 'Désactivé',
  deactivatedUserTitle: 'Utilisateur désactivé',
  delete: 'Effacer',
  deleteFormat: 'Supprimer le format',
  deleteMeeting: 'Supprimer la réunion',
  deleteServiceBody: 'Supprimer la structure de service',
  deleteUser: "Supprimer l'utilisateur",
  descriptionTitle: 'Description',
  details: 'Détails (numéro de ligne ou identifiant de réunion)',
  downloading: 'Téléchargement...',
  downloadLaravelLog: 'Télécharger le journal Laravel',
  downloadTranslationsForCurrentLanguage: 'Télécharger les traductions pour la langue sélectionnée lors de la connexion',
  downloadTranslationsSpreadsheet: 'Télécharger la feuille de calcul des traductions',
  durationTitle: 'Durée',
  editFormat: 'Modifier le format',
  editUser: "Modifier l'utilisateur",
  emailTitle: 'Email',
  error: 'Erreur',
  errorDownloading: 'Erreur lors du téléchargement',
  errors: 'Erreurs',
  extraInfoTitle: 'Informations supplémentaires',
  fileProcessedSuccessfully: '✓ Fichier traité avec succès',
  filter: 'Filtre',
  formatDeleteConflictError: "Erreur : le format n'a pas pu être supprimé car il est toujours associé à des réunions.",
  formatId: 'Identifiant du format',
  formatsTitle: 'Formats',
  formatTranslationIsRequired: 'Une traduction est requise pour toutes les langues pour les formats réservés.',
  formatTypeCode_ALERT: "Le format doit être particulièrement visible (exigence d'abstinence, etc.).",
  formatTypeCode_COMMON_NEEDS_OR_RESTRICTION: "Besoins et restrictions (réunion hommes, LGTBQ, pas d'enfants, etc.)",
  formatTypeCode_LANGUAGE: 'Langue',
  formatTypeCode_LOCATION: "Code d'emplacement (accessible en fauteuil roulant, stationnement limité, etc.)",
  formatTypeCode_MEETING_FORMAT: 'Format de la réunion (témoignage, étude de littérature, etc.)',
  formatTypeCode_NONE: 'Aucun',
  formatTypeCode_OPEN_OR_CLOSED: 'Participation de personnes non dépendantes (ouvert, fermé)',
  formatTypeTitle: 'Type de format',
  formatValidationError: 'Erreur : ce format est protégé et ne peut être supprimé.',
  geocodingFailed: 'Geocoding failed',
  googleGeocodingFailed: 'Google geocoding failed',
  googleKeyProblemDescription: 'The Google Maps API key is invalid or not properly configured. Please update your API key settings.',
  googleKeyProblemTitle: 'Google Maps API Key Problem',
  helplineTitle: 'Helpline',
  hideDetails: 'Masquer les détails',
  homeTitle: 'Accueil',
  hoursTitle: 'Horaires',
  idTitle: 'Identifiant',
  invalidUsernameOrPassword: 'Nom d’utilisateur ou mot de passe incorrect.',
  keyIsRequired: 'Ce champ est obligatoire.',
  keyIsReserved: 'Cette valeur existe déjà. Saisissez-en une autre.',
  keyTitle: 'Champ',
  languageSelectTitle: 'Sélectionner la langue',
  lastLoginTitle: 'Last Login',
  latitudeTitle: 'Latitude',
  loadFile: 'Charger le fichier',
  loading: 'chargement...',
  locationMapTitle: 'Location Map', // TOFIX: translate
  locationStreetErrorMessage: 'Les réunions hybrides ou en présentiel doivent avoir une adresse postale.',
  locationTextTitle: 'Texte de la localisation',
  loginTitle: 'Connexion',
  loginVerb: 'Se connecter',
  logout: 'Déconnexion',
  longitudeTitle: 'Longitude',
  malformedRows: 'Format de ligne invalide',
  meeting: 'réunion',
  meetingErrorsSomewhere: 'Onglets contenant une ou plusieurs erreurs :',
  meetingIsPublishedTitle: 'La réunion est publiée',
  meetingListEditorsTitle: 'Rédacteurs de la liste des réunions',
  meetings: 'réunions',
  meetingsPerPage: 'Réunions par page',
  meetingsTitle: 'Réunions',
  meetingUnpublishedNote: 'Note : dépublier une réunion indique une fermeture temporaire. Si cette réunion est définitivement fermée, veuillez la supprimer.',
  minutesTitle: 'Minutes',
  nameTitle: 'Nom',
  nationTitle: 'Nation',
  nawsFormat_BEG: 'Nouveau',
  nawsFormat_BT: 'Texte de base',
  nawsFormat_CAN: 'Éclairage à la bougie',
  nawsFormat_CH: 'Fermé les jours fériés',
  nawsFormat_CLOSED: 'Fermé',
  nawsFormat_CPT: '12 Concepts',
  nawsFormat_CW: 'Enfants bienvenus',
  nawsFormat_DISC: 'Partages',
  nawsFormat_GL: 'Gays/Lesbiennes',
  nawsFormat_GP: 'Principes directeurs',
  nawsFormat_HYBR: 'En ligne et en présentiel',
  nawsFormat_IP: 'Étude des brochures d’information publique',
  nawsFormat_IW: 'Étude de « Ça marche : comment et pourquoi »',
  nawsFormat_JFT: 'Étude de « Juste pour aujourd’hui »',
  nawsFormat_LANG: 'Autre langue',
  nawsFormat_LC: 'Vivre Clean',
  nawsFormat_LIT: 'Étude de la littérature',
  nawsFormat_M: 'Hommes',
  nawsFormat_MED: 'Méditation',
  nawsFormat_NC: "Pas d'enfants",
  nawsFormat_NONE: 'Aucun',
  nawsFormat_NS: 'Non-Fumeur',
  nawsFormat_OPEN: 'Ouvert',
  nawsFormat_QA: 'Questions et réponses',
  nawsFormat_RA: 'Accès restreint',
  nawsFormat_SD: 'Témoignage/partages',
  nawsFormat_SMOK: 'Fumeur',
  nawsFormat_SPAD: 'Principe spirituel du jour',
  nawsFormat_SPK: 'Témoignage',
  nawsFormat_STEP: 'Étape',
  nawsFormat_SWG: 'Étude du guide des étapes',
  nawsFormat_TC: 'Fermé temporairement',
  nawsFormat_TOP: 'Sujet',
  nawsFormat_TRAD: 'Tradition',
  nawsFormat_VAR: 'Format variable',
  nawsFormat_VM: 'En ligne',
  nawsFormat_W: 'Femmes',
  nawsFormat_WCHR: 'Accessible en fauteuil roulant',
  nawsFormat_Y: 'Jeunes',
  nawsFormatTitle: 'Format NAWS',
  neighborhoodTitle: 'Quartier',
  noChangesFound: 'No changes found',
  noFormatTranslationsError: 'Au moins une traduction est requise.',
  noLogsFound: 'Aucun journal trouvé',
  nominatimGeocodingFailed: 'Nominatim geocoding failed: no results found',
  none: '- Aucun -',
  noServiceBodiesTitle: 'Aucune structure de service trouvée que cet utilisateur peut modifier',
  notedAsDeleted: 'Noté comme supprimé',
  notFound: 'Introuvable',
  noTranslationAvailable: 'Aucune traduction disponible',
  noUpdateNeeded: 'Aucune mise à jour nécessaire',
  noUsersTitle: 'Aucun autre utilisateur modifiable par cet utilisateur.',
  noWhitespaceInKey: 'Les espaces blancs ne sont pas autorisés dans ce champ.',
  observerTitle: 'Observateur de la structure de service',
  occurredAt: 'Survenu à',
  ownedByTitle: 'Appartenant à',
  paginationOf: 'de',
  paginationShowing: 'Affichage',
  parentIdTitle: 'Structure de service parent',
  passwordTitle: 'Mot de passe',
  phoneMeetingTitle: "Numéro d'appel pour la réunion téléphonique",
  postMeridiem: 'Après-midi',
  processingFile: 'Traitement du fichier...',
  published: 'Publié',
  saveAsCopy: 'Enregistrer comme copie',
  saveAsCopyCheckbox: 'Enregistrer cette réunion comme copie (Crée une nouvelle réunion)',
  saveAsNewMeeting: 'Enregistrer comme nouvelle réunion',
  saving: 'Enregistrement...',
  search: 'Rechercher',
  searchByDay: 'Rechercher par jour',
  searchByName: 'Rechercher par nom',
  searchByServiceBody: 'Rechercher par structure de service',
  searchMeetings: 'Rechercher des réunions...',
  selectAllDays: 'Sélectionner tous les jours',
  selectAllServiceBodies: 'Sélectionner toutes les structures de service',
  serverAdministratorTitle: 'Administrateur principal du serveur',
  serverTitle: 'Serveur BMLT',
  serviceBodiesNoParent: 'Aucun parent (niveau supérieur)',
  serviceBodiesTitle: 'Structures de service',
  serviceBodiesWithEditableMeetings: 'Cet utilisateur peut modifier les réunions dans les structures suivantes :',
  serviceBodyAdminTitle: 'Administrateur de la structure de service',
  serviceBodyDeleteConflictError: "Erreur : la structure de service n'a pas pu être supprimée car elle est toujours associée à des réunions ou est le parent d'autres structures de service.",
  serviceBodyInvalid: 'Veuillez sélectionner une structure de service valide.',
  serviceBodyTitle: 'Structure de service',
  serviceBodyTypeTitle: 'Type de la structure de service',
  showAllTranslations: 'Afficher toutes les traductions',
  showDetails: 'Afficher les détails',
  startTimeTitle: 'Heure de début',
  stateTitle: 'État/Province',
  streetTitle: 'Rue',
  summary: 'Résumé',
  supportedFileFormats: 'Formats pris en charge : Excel (.xlsx) et CSV (.csv)',
  tabsBasic: 'Basique',
  tabsChanges: 'Changements',
  tabsLocation: 'Emplacement',
  tabsOther: 'Autre',
  technicalDetails: 'Détails techniques',
  time: 'Heure',
  timeAfternoon: 'Après-midi',
  timeEvening: 'Soir',
  timeMorning: 'Matin',
  timeZoneGeocodeError: 'Impossible de déterminer le fuseau horaire à partir des coordonnées. Veuillez sélectionner un fuseau horaire manuellement.',
  timeZoneInvalid: 'Fuseau horaire non valide',
  timeZoneSelectPlaceholder: "Choisissez une option (ou laissez le champ vide pour une détection automatique à partir de l'emplacement)",
  timeZoneTitle: 'Fuseau horaire',
  totalRows: 'Nombre total de lignes (hors en-tête)',
  trainLinesTitle: 'Lignes de train',
  unpublished: 'Non publié',
  unselectAllDays: 'Désélectionner tous les jours',
  unselectAllServiceBodies: 'Désélectionner toutes les structures de service',
  updated: 'Mis à jour',
  updateWorldCommitteeCodes: 'Mettre à jour les codes du Comité mondial',
  userDeleteConflictError: "Erreur : l'utilisateur n'a pas pu être supprimé car il est toujours associé à au moins une structure de service ou est le parent d'un autre utilisateur.",
  userIsDeactivated: "L'utilisateur est désactivé.",
  usernameTitle: "Nom d'utilisateur",
  usersTitle: 'Utilisateurs',
  userTitle: 'Utilisateur',
  userTypeTitle: "Type d'utilisateur",
  venueTypeTitle: 'Type de lieu',
  virtualMeetingAdditionalInfoTitle: 'Informations supplémentaires de la réunion en ligne',
  virtualMeetingTitle: 'Lien de la réunion en ligne',
  websiteUrlTitle: 'URL du site Web',
  welcome: 'Bienvenue',
  worldIdTitle: 'Code du Comité mondial',
  youHaveUnsavedChanges: 'Vous avez des modifications non enregistrées. Voulez-vous vraiment fermer ?',
  zipCodeTitle: 'Code postal'
};
