import type { LocaleObject } from 'yup';

export const faYupLocale: LocaleObject = {
  array: {
    length: '${path} must have ${length} items',
    max: '${path} field must have less than or equal to ${max} items',
    min: '${path} field must have at least ${min} items'
  },
  boolean: {
    isValue: '${path} field must be ${value}'
  },
  date: {
    max: '${path} field must be at earlier than ${max}',
    min: '${path} field must be later than ${min}'
  },
  mixed: {
    default: '${path} is invalid',
    defined: '${path} must be defined',
    notNull: '${path} cannot be null',
    notOneOf: '${path} must not be one of the following values: ${values}',
    notType: '${path} must be a valid type',
    oneOf: '${path} must be one of the following values: ${values}',
    required: '${path} is a required field'
  },
  number: {
    integer: '${path} must be an integer',
    lessThan: '${path} must be less than ${less}',
    max: '${path} must be less than or equal to ${max}',
    min: '${path} must be greater than or equal to ${min}',
    moreThan: '${path} must be greater than ${more}',
    negative: '${path} must be a negative number',
    positive: '${path} must be a positive number'
  },
  object: {
    exact: '${path} object contains unknown properties: ${properties}',
    noUnknown: '${path} field has unspecified keys: ${unknown}'
  },
  string: {
    datetime: '${path} must be a valid ISO date-time',
    datetime_offset: '${path} must be a valid ISO date-time with UTC "Z" timezone',
    datetime_precision: '${path} must be a valid ISO date-time with a sub-second precision of exactly ${precision} digits',
    email: '${path} must be a valid email',
    length: '${path} must be exactly ${length} characters',
    lowercase: '${path} must be a lowercase string',
    matches: '${path} must match the following: "${regex}"',
    max: '${path} must be at most ${max} characters',
    min: '${path} must be at least ${min} characters',
    trim: '${path} must be a trimmed string',
    uppercase: '${path} must be a upper case string',
    url: '${path} must be a valid URL',
    uuid: '${path} must be a valid UUID'
  },
  tuple: {
    notType: '${path} must be a valid tuple type'
  }
};

/*eslint sort-keys: ["error", "asc", {caseSensitive: false}]*/
export const faTranslations = {
  accountSettingsTitle: 'تنظیمات حساب',
  accountTitle: 'حساب',
  accountTypeTitle: 'نوع حساب',
  addFormat: 'افزودن فرمت',
  addMeeting: 'افزودن جلسه',
  addServiceBody: 'افزودن بدنه خدماتی',
  addUser: 'افزودن کاربر',
  administrationTitle: 'اداره',
  administratorTitle: 'مدیر',
  adminTitle: 'ادمین',
  anteMeridiem: 'ق.ظ',
  applyChangesTitle: 'ذخیره تغییرات',
  automaticallyCalculatedOnSave: 'Automatically calculated on save',
  boroughTitle: 'بخش منطقه/شهر',
  busLinesTitle: 'خطوط اتوبوس',
  by: 'بوسیله',
  cancel: 'لغو',
  chooseStartTime: 'انتخاب زمان شروع',
  cityTownTitle: 'شهر/شهر',
  clearFormTitle: 'پاک کردن فرم',
  close: 'بستن',
  closeWithoutSaving: 'بستن بدون ذخیره کردن',
  commentsTitle: 'نظرات',
  confirmDeleteFormat: 'آیا مطمئن هستید که می خواهید این فرمت را حذف کنید؟',
  confirmDeleteMeeting: 'آیا مطمئن هستید که می خواهید این جلسه را حذف کنید؟',
  confirmDeleteServiceBody: 'آیا مطمئن هستید که می خواهید این بدنه سرویس را حذف کنید؟',
  confirmDeleteUser: 'آیا مطمئن هستید که می خواهید این کاربر را حذف کنید؟',
  confirmYesImSure: 'بله، مطمئنم',
  contact1EmailTitle: 'با ایمیل 1 تماس بگیرید',
  contact1NameTitle: 'با نام 1 تماس بگیرید',
  contact1PhoneTitle: 'با تلفن 1 تماس بگیرید',
  contact2EmailTitle: 'با ایمیل 2 تماس بگیرید',
  contact2NameTitle: 'با نام 2 تماس بگیرید',
  contact2PhoneTitle: 'با تلفن 2 تماس بگیرید',
  copyToClipboard: 'کپی در کلیپبورد',
  countySubProvinceTitle: 'شهرستان/بخش',
  dashboardTitle: 'داشبورد',
  day: 'روز',
  day0: 'یکشنبه',
  day1: 'دوشنبه',
  day2: 'سه‌شنبه',
  day3: 'چهارشنبه',
  day4: 'پنج‌شنبه',
  day5: 'جمعه',
  day6: 'شنبه',
  dayTitle: 'ایام هفته',
  deactivatedTitle: 'غیرفعال',
  deactivatedUserTitle: 'کاربر غیرفعال',
  delete: 'حذف کردن',
  deleteFormat: 'حذف فرمت',
  deleteMeeting: 'حذف جلسه',
  deleteServiceBody: 'حذف بدنه سرویس',
  deleteUser: 'حذف کاربر',
  descriptionTitle: 'توضیحات',
  details: 'جزئیات (شماره ردیف یا شناسه جلسه)',
  downloading: 'در حال دانلود ...',
  downloadLaravelLog: 'دانلود ورود به سیستم Laravel',
  downloadTranslationsForCurrentLanguage: 'Download translations for the language selected at login',
  downloadTranslationsSpreadsheet: 'Download Translations Spreadsheet',
  durationTitle: 'مدت',
  editFormat: 'ویرایش فرمت',
  editUser: 'ویرایش کاربر',
  emailTitle: 'ایمیل',
  error: 'خطا',
  errorDownloading: 'Error Downloading',
  errors: 'خطاها',
  extraInfoTitle: 'اطلاعات اضافی',
  fileProcessedSuccessfully: 'پرونده با موفقیت پردازش شد',
  filter: 'فیلتر',
  formatDeleteConflictError: 'خطا: این فرمت قابل حذف نیست زیرا هنوز با جلسات همراه است.',
  formatId: 'شناسه فرمت',
  formatsTitle: 'فرمت ها',
  formatTranslationIsRequired: 'ترجمه ای برای همه زبانها برای فرمت های رزرو شده لازم است',
  formatTypeCode_ALERT: 'Format should be especially prominent (Clean requirement, etc.)',
  formatTypeCode_COMMON_NEEDS_OR_RESTRICTION: 'Common Needs and Restrictions (Mens Meeting, LGTBQ, No Children, etc.)',
  formatTypeCode_LANGUAGE: 'Language',
  formatTypeCode_LOCATION: 'Location Code (Wheelchair Accessible, Limited Parking, etc.)',
  formatTypeCode_MEETING_FORMAT: 'Meeting Format (Speaker, Book Study, etc.)',
  formatTypeCode_NONE: 'None',
  formatTypeCode_OPEN_OR_CLOSED: 'Attendance by non-addicts (Open, Closed)',
  formatTypeTitle: 'نوع فرمت',
  formatValidationError: 'خطا: این قالب فرمت می شود و نمی توان حذف شد.',
  geocodingFailed: 'Geocoding failed',
  googleGeocodingFailed: 'Google geocoding failed',
  googleKeyProblemDescription: 'The Google Maps API key is invalid or not properly configured. Please update your API key settings.',
  googleKeyProblemTitle: 'Google Maps API Key Problem',
  helplineTitle: 'راهنمای تماس تلفنی',
  hideDetails: 'مخفی کردن جزئیات',
  homeTitle: 'خانه',
  hoursTitle: 'ساعت',
  idTitle: 'شناسه',
  invalidUsernameOrPassword: 'نام کاربری یا رمز عبور نامعتبر است.',
  keyIsRequired: 'کلید لازم است',
  keyIsReserved: 'کلید محفوظ است - لطفا از چیز دیگری استفاده کنید',
  keyTitle: 'کلید',
  languageSelectTitle: 'انتخاب زبان',
  lastLoginTitle: 'Last Login',
  latitudeTitle: 'عرض جغرافیایی',
  loadFile: 'بارگیری پرونده',
  loading: 'بارگیری ...',
  locationMapTitle: 'نقشه مکان',
  locationStreetErrorMessage: 'جلسات ترکیبی یا حضوری باید آدرس خیابان داشته باشند.',
  locationTextTitle: 'متن مکان',
  loginTitle: 'ورود',
  loginVerb: 'وارد شدن',
  logout: 'ورود به سیستم',
  longitudeTitle: 'طول جغرافیایی',
  malformedRows: 'ردیف های ناقص',
  meeting: 'جلسه',
  meetingErrorsSomewhere: 'زبانه ها با یک یا چند خطای:',
  meetingIsPublishedTitle: 'جلسه منتشر شد',
  meetingListEditorsTitle: 'ویرایشگرهای لیست جلسه',
  meetings: 'جلسات',
  meetingsPerPage: 'جلسات در هر صفحه',
  meetingsTitle: 'جلسات',
  meetingUnpublishedNote: 'توجه: انتشار جلسه نشانگر بسته شدن موقت است. اگر این جلسه به طور دائم بسته شده است ، لطفاً آن را حذف کنید.',
  minutesTitle: 'دقیقه',
  nameTitle: 'نام',
  nationTitle: 'ملیت',
  nawsFormat_BEG: 'Beginner/Newcomer',
  nawsFormat_BT: 'Basic Text',
  nawsFormat_CAN: 'Candlelight',
  nawsFormat_CH: 'Closed Holidays',
  nawsFormat_CLOSED: 'Closed',
  nawsFormat_CPT: '12 Concepts',
  nawsFormat_CW: 'Children Welcome',
  nawsFormat_DISC: 'Discussion/Participation',
  nawsFormat_GL: 'Gay/Lesbian',
  nawsFormat_GP: 'Guiding Principles',
  nawsFormat_HYBR: 'Virtual and In-Person',
  nawsFormat_IP: 'IP Study',
  nawsFormat_IW: 'It Works Study',
  nawsFormat_JFT: 'Just For Today Study',
  nawsFormat_LANG: 'Alternate Language',
  nawsFormat_LC: 'Living Clean',
  nawsFormat_LIT: 'Literature Study',
  nawsFormat_M: 'Men',
  nawsFormat_MED: 'Meditation',
  nawsFormat_NC: 'No Children',
  nawsFormat_NONE: 'None',
  nawsFormat_NS: 'Non-Smoking',
  nawsFormat_OPEN: 'Open',
  nawsFormat_QA: 'Questions & Answers',
  nawsFormat_RA: 'Restricted Access',
  nawsFormat_SD: 'Speaker/Discussion',
  nawsFormat_SMOK: 'Smoking',
  nawsFormat_SPAD: 'Spiritual Principle a Day',
  nawsFormat_SPK: 'Speaker',
  nawsFormat_STEP: 'Step',
  nawsFormat_SWG: 'Step Working Guide Study',
  nawsFormat_TC: 'Temporarily Closed Facility',
  nawsFormat_TOP: 'Topic',
  nawsFormat_TRAD: 'Tradition',
  nawsFormat_VAR: 'Format Varies',
  nawsFormat_VM: 'Virtual',
  nawsFormat_W: 'Women',
  nawsFormat_WCHR: 'Wheelchair-Accessible',
  nawsFormat_Y: 'Young People',
  nawsFormatTitle: 'فرمت NAWS',
  neighborhoodTitle: 'محله',
  noChangesFound: 'No changes found',
  noFormatTranslationsError: 'حداقل یک ترجمه لازم است.',
  noLogsFound: 'هیچ گزارشی یافت نشد',
  nominatimGeocodingFailed: 'Nominatim geocoding failed: no results found',
  none: '- هیچ کدام -',
  noServiceBodiesTitle: 'هیچ بدنه خدماتی نیست که این کاربر بتواند ویرایش کند',
  notedAsDeleted: 'به عنوان حذف شده یادداشت شد',
  notFound: 'یافت نشد',
  noTranslationAvailable: 'ترجمه ای موجود نیست', // TODO: check this translation
  noUpdateNeeded: 'نیازی به آپدیت نیست',
  noUsersTitle: 'کاربری دیگری یافت نشد که این کاربر بتواند ویرایش کند',
  noWhitespaceInKey: 'فضای خالی در کلید مجاز نیست',
  observerTitle: 'ناظر بدنه خدماتی',
  occurredAt: 'رخ داده در',
  ownedByTitle: 'متعلق به',
  paginationOf: 'از',
  paginationShowing: 'نشان',
  parentIdTitle: 'والد بدنه خدماتی',
  passwordTitle: 'رمز',
  phoneMeetingTitle: 'شماره تماس جلسه تلفنی',
  postMeridiem: 'ب.ظ',
  processingFile: 'پردازش پرونده ...',
  published: 'منتشر شده',
  saveAsCopy: 'ذخیره به عنوان کپی',
  saveAsCopyCheckbox: 'این جلسه را به عنوان کپی ذخیره کنید (جلسه جدید ایجاد می‌کند)',
  saveAsNewMeeting: 'به عنوان جلسه جدید ذخیره کنید',
  saving: 'در حال ذخیره...',
  search: 'جستجو',
  searchByDay: 'جستجو براساس روز',
  searchByName: 'جستجو بر اساس نام',
  searchByServiceBody: 'جستجو بر اساس بدنه خدماتی',
  searchMeetings: 'جستجوی جلسات ...',
  selectAllDays: 'انتخاب همه روزها',
  selectAllServiceBodies: 'انتخاب تمام نهادهای خدماتی',
  serverAdministratorTitle: 'مدیر سرور اصلی',
  serverTitle: 'سرور BMLT',
  serviceBodiesNoParent: 'بدون والد(سطح بالا)',
  serviceBodiesTitle: 'بدنه خدماتی',
  serviceBodiesWithEditableMeetings: 'این کاربر می تواند جلسات را در این بدنه خدماتی ویرایش کند:',
  serviceBodyAdminTitle: 'مدیر بدنه خدماتی',
  serviceBodyDeleteConflictError: 'خطا: بدنه خدمات نمی تواند حذف شود زیرا هنوز با جلسات همراه است یا والدین سایر نهادهای خدماتی است.',
  serviceBodyInvalid: 'لطفاً یک بدنه خدماتی معتبر را انتخاب کنید',
  serviceBodyTitle: 'بدنه خدماتی',
  serviceBodyTypeTitle: 'نوع بدنه خدماتی',
  showAllTranslations: 'مشاهده همه ترجمه ها',
  showDetails: 'نمایش جزئیات',
  startTimeTitle: 'زمان شروع',
  stateTitle: 'ایالت/استان',
  streetTitle: 'خیابان',
  summary: 'خلاصه',
  supportedFileFormats: 'قالبهای پشتیبانی شده: اکسل (.xlsx) و CSV (.csv)',
  tabsBasic: 'پایه',
  tabsChanges: 'تغییرات',
  tabsLocation: 'مکان',
  tabsOther: 'دیگر',
  technicalDetails: 'جزئیات فنی',
  time: 'زمان',
  timeAfternoon: 'بعد از ظهر',
  timeEvening: 'شب',
  timeMorning: 'صبح',
  timeZoneGeocodeError: 'تعیین منطقه زمانی از مختصات امکان پذیر نیست. لطفاً یک منطقه زمانی را به صورت دستی انتخاب کنید',
  timeZoneInvalid: 'منطقه زمانی نامعتبر',
  timeZoneSelectPlaceholder: 'گزینه را انتخاب کنید (یا برای تشخیص خودکار از موقعیت مکانی، خالی بگذارید)',
  timeZoneTitle: 'منطقه زمانی',
  totalRows: 'مجموع ردیف‌ها (به استثنای سربرگ)',
  trainLinesTitle: 'خطوط قطار',
  unpublished: 'منتشر نشده',
  unselectAllDays: 'لغو انتخاب همه روزها',
  unselectAllServiceBodies: 'همه بدنه های خدماتی را انتخاب نکنید',
  updated: 'به روز شد',
  updateWorldCommitteeCodes: 'کدهای کمیته جهانی را به روز کنید',
  userDeleteConflictError: 'خطا: کاربر نمی تواند حذف شود زیرا هنوز حداقل با یک بدنه خدماتی همراه است یا والد کاربر دیگری است.',
  userIsDeactivated: 'کاربر غیرفعال شده است.',
  usernameTitle: 'نام کاربری',
  usersTitle: 'کاربران',
  userTitle: 'کاربر',
  userTypeTitle: 'نوع کاربر',
  venueTypeTitle: 'نوع محل برگزاری',
  virtualMeetingAdditionalInfoTitle: 'اطلاعات تکمیلی جلسه مجازی',
  virtualMeetingTitle: 'پیوند جلسه مجازی',
  websiteUrlTitle: 'آدرس سایت',
  welcome: 'خوش آمدید',
  worldIdTitle: 'کد کمیته جهانی',
  youHaveUnsavedChanges: 'شما تغییرات دخیره نشده ای داشته اید. آیا واقعاً می خواهید ببندید؟',
  zipCodeTitle: 'کد پستی/کد پستی'
};
