import type { LocaleObject } from 'yup';

/*eslint sort-keys: ["error", "asc", {caseSensitive: false}]*/
export const deTranslations = {
  accountSettingsTitle: 'Account Einstellungen',
  accountTitle: 'Account',
  accountTypeTitle: 'Account Typ',
  addFormat: 'Format hinzufügen',
  addMeeting: 'Meeting hinzufügen',
  addServiceBody: 'Service-Body hinzufügen',
  addUser: 'Benutzer hinzufügen',
  administrationTitle: 'Administration',
  administratorTitle: 'Administrator*in',
  adminTitle: 'Admin',
  anteMeridiem: 'AM',
  applyChangesTitle: 'Änderung anwenden',
  automaticallyCalculatedOnSave: 'Wird automatisch beim Speichern berechnet',
  boroughTitle: 'Stadtviertel', // TODO: check this - English is Borough/City Subsection
  busLinesTitle: 'Buslinien',
  by: 'von',
  cancel: 'Stornieren',
  chooseStartTime: 'Startzeit wählen',
  cityTownTitle: 'Stadt',
  clearFormTitle: 'Formular löschen',
  close: 'Schließen',
  closeWithoutSaving: 'Schließen ohne zu speichern',
  commentsTitle: 'Kommentare',
  confirmDeleteFormat: 'Bist du sicher, dass du dieses Format löschen möchtest?',
  confirmDeleteMeeting: 'Bist du sicher, dass du dieses Meeting löschen möchtest?',
  confirmDeleteServiceBody: 'Bist du sicher, dass du diesen Service-Body löschen möchtest?',
  confirmDeleteUser: 'Bist du sicher, dass du diesen Benutzer löschen möchtest?',
  confirmYesImSure: 'Ja, ich bin sicher.',
  contact1EmailTitle: 'Kontakt 1 E-Mail',
  contact1NameTitle: 'Kontakt 1 Name',
  contact1PhoneTitle: 'Kontakt 1 Telefon',
  contact2EmailTitle: 'Kontakt 2 E-Mail',
  contact2NameTitle: 'Kontakt 2 Name',
  contact2PhoneTitle: 'Kontakt 2 Telefon',
  copyToClipboard: 'In Zwischenablage kopieren',
  countySubProvinceTitle: 'Bezirk', //  // TODO: check this - English is County/Sub-Province
  dashboardTitle: 'Dashboard',
  day: 'Tag',
  day0: 'Sonntag',
  day1: 'Montag',
  day2: 'Dienstag',
  day3: 'Mittwoch',
  day4: 'Donnerstag',
  day5: 'Freitag',
  day6: 'Samstag',
  dayTitle: 'Wochentag',
  deactivatedTitle: 'Deaktiviert',
  deactivatedUserTitle: 'Deaktivierter Benutzer',
  delete: 'Löschen',
  deleteFormat: 'Format löschen',
  deleteMeeting: 'Meeting löschen',
  deleteServiceBody: 'Service-Body löschen',
  deleteUser: 'Lösche diesen Benutzer',
  descriptionTitle: 'Beschreibung',
  details: 'Details (row number or meeting ID)', // TODO: translate
  downloading: 'Downloading...',
  downloadLaravelLog: 'Download Laravel Log',
  downloadTranslationsForCurrentLanguage: 'Download Übersetzung der beim Login ausgewählten Sprache',
  downloadTranslationsSpreadsheet: 'Übersetzungstabelle herunterladen',
  durationTitle: 'Dauer',
  editFormat: 'Format bearbeiten',
  editUser: 'Benutzer bearbeiten',
  emailTitle: 'E-Mail-Adresse',
  error: 'Fehler',
  errorDownloading: 'Error Downloading',
  errors: 'Fehler',
  extraInfoTitle: 'Weitere Informationen',
  fileProcessedSuccessfully: '✓ File Processed Successfully', // TODO: translate
  filter: 'Filter',
  formatDeleteConflictError: 'Fehler: Das Format konnte nicht gelöscht werden, da es noch mit Meetings verknüpft ist.',
  formatId: 'Format-ID',
  formatsTitle: 'Formate',
  formatTranslationIsRequired: 'Für reservierte Formate ist eine Übersetzung für alle Sprachen erforderlich',
  formatTypeCode_ALERT: 'Das Format sollte besonders hervorgehoben werden (Cleanzeitanforderung usw.).',
  formatTypeCode_COMMON_NEEDS_OR_RESTRICTION: 'Allgemeine Bedürfnisse und Einschränkungen (Männermeeting, LGBTQ, keine Kinder usw.)',
  formatTypeCode_LANGUAGE: 'Sprache',
  formatTypeCode_LOCATION: 'Standortcode (Rollstuhlgerecht, begrenzte Parkmöglichkeiten usw.)',
  formatTypeCode_MEETING_FORMAT: 'Meetingsformat (Sprecher, Lesen aus NA-Literatur usw.)',
  formatTypeCode_NONE: 'Keine',
  formatTypeCode_OPEN_OR_CLOSED: 'Teilnahme von Nichtsüchtigen (offen, geschlossen)',
  formatTypeTitle: 'Formattyp',
  formatValidationError: 'Fehler: Dieses Format ist geschützt und kann nicht gelöscht werden.',
  geocodingFailed: 'Geocoding fehlgeschlagen',
  googleGeocodingFailed: 'Google-geocoding fehlgeschlagen',
  googleKeyProblemDescription: 'Der Google Maps API-Schlüssel ist ungültig oder nicht korrekt konfiguriert. Bitte aktualisier deine API-Schlüsseleinstellungen.',
  googleKeyProblemTitle: 'Google Maps API-Schlüsselproblem',
  helplineTitle: 'Helpline',
  hideDetails: 'Details ausblenden',
  homeTitle: 'Startseite',
  hoursTitle: 'Std.',
  idTitle: 'ID',
  invalidUsernameOrPassword: 'Ungültiger Benutzername oder Passwort.',
  keyIsRequired: 'Schlüssel ist erforderlich',
  keyIsReserved: 'Schlüssel ist reserviert -- bitte verwende etwas anderes',
  keyTitle: 'Schlüssel',
  languageSelectTitle: 'Sprache auswählen',
  lastLoginTitle: 'Last Login',
  latitudeTitle: 'Breitengrad',
  loadFile: 'Load file', // TODO: translate
  loading: 'loading ...',
  locationMapTitle: 'Lageplan',
  locationStreetErrorMessage: 'Für Hybrid- oder Präsenz-Meetings muss eine Straßenadresse angegeben werden.',
  locationTextTitle: 'Standorttext',
  loginTitle: 'Login',
  loginVerb: 'Anmelden',
  logout: 'Abmelden',
  longitudeTitle: 'Längengrad',
  malformedRows: 'Malformed rows', // TODO: Translate
  meeting: 'Meeting',
  meetingErrorsSomewhere: 'Tabs mit einem oder mehreren Fehlern:',
  meetingIsPublishedTitle: 'Meeting ist veröffentlicht',
  meetingListEditorsTitle: 'Meetingsliste Editors', // TODO: check translation
  meetings: 'Meetings',
  meetingsPerPage: 'Meetings per page', // TODO: Translate
  meetingsTitle: 'Meeting',
  meetingUnpublishedNote:
    'Hinweis: Das Aufheben der Veröffentlichung eines Meetings bedeutet, dass es vorübergehend geschlossen wurde. Wenn dieses Meeting dauerhaft geschlossen wurde, lösch es bitte.',
  minutesTitle: 'Minuten',
  nameTitle: 'Name',
  nationTitle: 'Land',
  nawsFormat_BEG: 'Neuankömmlinge',
  nawsFormat_BT: 'BasicText',
  nawsFormat_CAN: 'Kerzenlicht',
  nawsFormat_CH: 'An Feiertagen geschlossen',
  nawsFormat_CLOSED: 'Geschlossen',
  nawsFormat_CPT: '12 Konzepte',
  nawsFormat_CW: 'Kinderfreundlich',
  nawsFormat_DISC: 'Diskussion/Teilen',
  nawsFormat_GL: 'LGBTQ*',
  nawsFormat_GP: 'Guiding Principles',
  nawsFormat_HYBR: 'Hybrid',
  nawsFormat_IP: 'Thema Faltblätter',
  nawsFormat_IW: 'Es funktioniert',
  nawsFormat_JFT: 'Nur für Heute',
  nawsFormat_LANG: 'Sprache',
  nawsFormat_LC: 'Clean Leben',
  nawsFormat_LIT: 'Literatur',
  nawsFormat_M: 'Männermeeting',
  nawsFormat_MED: 'Meditation',
  nawsFormat_NC: 'Keine Kinder',
  nawsFormat_NONE: 'Keine',
  nawsFormat_NS: 'Rauchen verboten',
  nawsFormat_OPEN: 'offen für Nicht-Süchtige',
  nawsFormat_QA: 'Frage und Antwort',
  nawsFormat_RA: 'Eingeschränkter Zutritt',
  nawsFormat_SD: 'Sprecher / Diskussion',
  nawsFormat_SMOK: 'Rauchen erlaubt',
  nawsFormat_SPAD: 'Ein spirituelles Prinzip pro Tag',
  nawsFormat_SPK: 'Sprecher',
  nawsFormat_STEP: 'Schritte',
  nawsFormat_SWG: 'Schritteleitfaden',
  nawsFormat_TC: 'Vorübergehend geschlossene Einrichtung',
  nawsFormat_TOP: 'Themenmeeting',
  nawsFormat_TRAD: 'Traditionen',
  nawsFormat_VAR: 'Wechselndes Format',
  nawsFormat_VM: 'Virtual',
  nawsFormat_W: 'Frauenmeeting',
  nawsFormat_WCHR: 'Barrierefrei',
  nawsFormat_Y: 'Junge Menschen',
  nawsFormatTitle: 'NAWS Format',
  neighborhoodTitle: 'Nachbarschaft',
  noChangesFound: 'No changes found',
  noFormatTranslationsError: 'Es ist mindestens eine Übersetzung erforderlich.',
  noLogsFound: 'Keine Log-Einträge gefunden',
  nominatimGeocodingFailed: 'Nominatim-geocoding Fehler: keine Ergebnisse gefunden',
  none: '- Keine -',
  noServiceBodiesTitle: 'Es wurden keine Service-Bodies gefunden, die dieser Benutzer bearbeiten kann',
  notedAsDeleted: 'Noted as deleted', // TODO: Translate
  notFound: 'Not found', // TODO: Translate
  noTranslationAvailable: 'Keine Übersetzung verfügbar',
  noUpdateNeeded: 'No update needed', // TODO: Translate
  noUsersTitle: 'Es wurden keine anderen Benutzer gefunden, die dieser Benutzer bearbeiten kann',
  noWhitespaceInKey: 'Leerzeichen im Schlüssel sind nicht erlaubt',
  observerTitle: 'Service-Body Beobachter',
  occurredAt: 'Aufgetreten um',
  ownedByTitle: 'Gehört',
  paginationOf: 'von',
  paginationShowing: 'Zeigt',
  parentIdTitle: 'Service-Body Eltern', // TODO: check translation
  passwordTitle: 'Passwort',
  phoneMeetingTitle: 'Telefonnummer für Telefonmeeting',
  postMeridiem: 'PM',
  processingFile: 'Processing file...', // TODO: Translate
  published: 'Veröffentlicht',
  saveAsCopy: 'Als Kopie speichern',
  saveAsCopyCheckbox: 'Dieses Meeting als Kopie speichern (Erstellt ein neues Meeting)',
  saveAsNewMeeting: 'Als neue Sitzung speichern',
  saving: 'Speichern...',
  search: 'Suchen',
  searchByDay: 'Suche nach Tag',
  searchByName: 'Suche nach Name',
  searchByServiceBody: 'Suche nach Service-Body',
  searchMeetings: 'Suche Meetings...',
  selectAllDays: 'Alle Tage auswählen',
  selectAllServiceBodies: 'Select All Service Bodies', // TODO: Translate
  serverAdministratorTitle: 'Hauptserveradministrator*in',
  serverTitle: 'BMLT-Server',
  serviceBodiesNoParent: 'Kein übergeordnetes Element (oberste Ebene)',
  serviceBodiesTitle: 'Service-Bodies',
  serviceBodiesWithEditableMeetings: 'Dieser Benutzer kann Meetings in diesen Service-Bodies bearbeiten:',
  serviceBodyAdminTitle: 'Service-Body Administrator*in',
  serviceBodyDeleteConflictError: 'Fehler: Der Service-Body konnte nicht gelöscht werden, da er noch mit Meetings verknüpft ist oder anderen Service-Bodies übergeordnet ist.',
  serviceBodyInvalid: 'Bitte wähle einen gültigen service body aus',
  serviceBodyTitle: 'Service-Body',
  serviceBodyTypeTitle: 'Service-Body-Typ',
  showAllTranslations: 'Alle Übersetzungen anzeigen',
  showDetails: 'Details anzeigen',
  startTimeTitle: 'Startzeit',
  stateTitle: 'Staat/Landkreis',
  streetTitle: 'Straße',
  summary: 'Übersicht',
  supportedFileFormats: 'Supported formats: Excel (.xlsx) and CSV (.csv)', // TODO: Translate
  tabsBasic: 'Basic',
  tabsChanges: 'Änderungen',
  tabsLocation: 'Standort',
  tabsOther: 'Andere',
  technicalDetails: 'Technische Details',
  time: 'Zeit',
  timeAfternoon: 'Nachmittag',
  timeEvening: 'Abend',
  timeMorning: 'Morgen',
  timeZoneGeocodeError: 'Koordinaten der Zeitzone nicht ermittelbar. Bitte wähle Zeitzone manuell aus.',
  timeZoneInvalid: 'Ungültige Zeitzone',
  timeZoneSelectPlaceholder: 'Option auswählen (oder leer lassen, um die automatische Erkennung anhand des Standorts zu aktivieren)',
  timeZoneTitle: 'Zeitzone',
  totalRows: 'Total rows (excluding header)', // TODO: Translate
  trainLinesTitle: 'Zuglinien',
  unpublished: 'Unveröffentlicht',
  unselectAllDays: 'Auswahl für „Alle Tage“ aufheben',
  unselectAllServiceBodies: 'Unselect All Service Bodies', // TODO: Translate
  updated: 'Updated', // TODO: Translate
  updateWorldCommitteeCodes: 'Update World Committee Codes', // TODO: Translate
  userDeleteConflictError: 'Fehler: Der Benutzer konnte nicht gelöscht werden, da er noch mindestens einem Service-Body zugeordnet ist oder das übergeordnete Element eines anderen Benutzers ist.',
  userIsDeactivated: 'Benutzer ist deaktiviert.',
  usernameTitle: 'Benutzername',
  usersTitle: 'Benutzer',
  userTitle: 'Benutzer',
  userTypeTitle: 'Benutzertyp',
  venueTypeTitle: 'Art des Veranstaltungsortes',
  virtualMeetingAdditionalInfoTitle: 'Online-Meeting Weitere Informationen',
  virtualMeetingTitle: 'Online-Meeting URL',
  websiteUrlTitle: 'Website-URL',
  welcome: 'Willkommen',
  worldIdTitle: 'World-Committee ID',
  youHaveUnsavedChanges: 'Du hast nicht gespeicherte Änderungen. Möchtest du wirklich schließen?',
  zipCodeTitle: 'Postleitzahl'
};

export const deYupLocale: LocaleObject = {
  array: {
    length: '${path} must have ${length} items',
    max: '${path} field must have less than or equal to ${max} items',
    min: '${path} field must have at least ${min} items'
  },
  boolean: {
    isValue: '${path} field must be ${value}'
  },
  date: {
    max: '${path} field must be at earlier than ${max}',
    min: '${path} field must be later than ${min}'
  },
  mixed: {
    default: '${path} is invalid',
    defined: '${path} must be defined',
    notNull: '${path} cannot be null',
    notOneOf: '${path} must not be one of the following values: ${values}',
    notType: '${path} must be a valid type',
    oneOf: '${path} must be one of the following values: ${values}',
    required: '${path} is a required field'
  },
  number: {
    integer: '${path} must be an integer',
    lessThan: '${path} must be less than ${less}',
    max: '${path} must be less than or equal to ${max}',
    min: '${path} must be greater than or equal to ${min}',
    moreThan: '${path} must be greater than ${more}',
    negative: '${path} must be a negative number',
    positive: '${path} must be a positive number'
  },
  object: {
    exact: '${path} object contains unknown properties: ${properties}',
    noUnknown: '${path} field has unspecified keys: ${unknown}'
  },
  string: {
    datetime: '${path} must be a valid ISO date-time',
    datetime_offset: '${path} must be a valid ISO date-time with UTC "Z" timezone',
    datetime_precision: '${path} must be a valid ISO date-time with a sub-second precision of exactly ${precision} digits',
    email: '${path} must be a valid email',
    length: '${path} must be exactly ${length} characters',
    lowercase: '${path} must be a lowercase string',
    matches: '${path} must match the following: "${regex}"',
    max: '${path} must be at most ${max} characters',
    min: '${path} must be at least ${min} characters',
    trim: '${path} must be a trimmed string',
    uppercase: '${path} must be a upper case string',
    url: '${path} must be a valid URL',
    uuid: '${path} must be a valid UUID'
  },
  tuple: {
    notType: '${path} must be a valid tuple type'
  }
};
