<?php

namespace App;

class LegacyConfig
{
    private static ?array $config = null;
    private static bool $configLoaded = false;

    public static function get(?string $key = null, $default = null)
    {
        if (!self::$configLoaded) {
            self::loadConfig();
        }

        if (is_null(self::$config)) {
            return null;
        }

        if (is_null($key)) {
            return self::$config;
        }

        return self::$config[$key] ?? $default;
    }

    public static function set(string $key, $value)
    {
        // really should only be used in testing
        if (!self::$configLoaded) {
            self::loadConfig();
        }

        self::$config[$key] = $value;
    }

    public static function remove(string $key)
    {
        // really should only be used in testing
        if (!self::$configLoaded) {
            self::loadConfig();
        }

        unset(self::$config[$key]);
    }

    public static function reset()
    {
        // really should only be used in testing
        self::$config = null;
        self::$configLoaded = false;
    }

    private static function loadConfig()
    {
        $legacyConfigFile = base_path() . '/../auto-config.inc.php';
        if (file_exists($legacyConfigFile)) {
            defined('BMLT_EXEC') or define('BMLT_EXEC', 1);
            require($legacyConfigFile);
        } elseif (env('GITHUB_ACTIONS') != 'true') {
            die('<h1>Configuration Problem</h1>
              <p>The file <code>auto-config.inc.php</code> was not found.</p>
              <p>If this is a brand new BMLT server installation, please see the installation instructions. The latest version
              of the instructions is available at
              <a href="https://github.com/bmlt-enabled/bmlt-server/blob/main/installation/README.md">
                https://github.com/bmlt-enabled/bmlt-server/blob/main/installation/README.md</a>.
              For other versions, get a copy of the BMLT server source code from github, check out the version you want,
              and look in the file <code>installation/README.md</code>.</p>');
        }

        $config = [];

        if (isset($gkey)) {
            $config['google_api_key'] = $gkey;
        } elseif (isset($gKey)) {
            $config['google_api_key'] = $gKey;
        }

        if (isset($dbName)) {
            $config['db_database'] = $dbName;
        }

        if (isset($dbUser)) {
            $config['db_username'] = $dbUser;
        }

        if (isset($dbPassword)) {
            $config['db_password'] = $dbPassword;
        }

        if (isset($dbServer)) {
            $config['db_host'] = $dbServer;
        }

        if (isset($dbPrefix)) {
            $config['db_prefix'] = $dbPrefix;
        }

        if (isset($change_depth_for_meetings)) {
            $config['change_depth_for_meetings'] = intval($change_depth_for_meetings);
        }

        if (isset($default_sort_key)) {
            $config['default_sort_key'] = $default_sort_key;
        }

        $config['language'] = $comdef_global_language ?? 'en';
        $config['default_duration_time'] = $default_duration_time ?? '01:00:00';
        $config['region_bias'] = $region_bias ?? 'us';
        $config['distance_units'] = $comdef_distance_units ?? 'mi';
        $config['enable_email_contact'] = isset($g_enable_email_contact) && $g_enable_email_contact;
        $config['include_service_body_admin_on_emails'] = isset($include_service_body_admin_on_emails) && $include_service_body_admin_on_emails;
        $config['change_depth_for_meetings'] = $change_depth_for_meetings ?? 0;
        $config['meeting_states_and_provinces'] = isset($meeting_states_and_provinces) && is_string($meeting_states_and_provinces)
            ? collect(explode(',', $meeting_states_and_provinces))->map(fn($id) => trim($id))->toArray()
            : ($meeting_states_and_provinces ?? []);
        $config['meeting_counties_and_sub_provinces'] = isset($meeting_counties_and_sub_provinces) && is_string($meeting_counties_and_sub_provinces)
            ? collect(explode(',', $meeting_counties_and_sub_provinces))->map(fn($id) => trim($id))->toArray()
            : ($meeting_counties_and_sub_provinces ?? []);
        $config['search_spec_map_center_longitude'] = isset($search_spec_map_center) && is_array($search_spec_map_center) && isset($search_spec_map_center['longitude']) ? $search_spec_map_center['longitude'] : -118.563659;
        $config['search_spec_map_center_latitude'] = isset($search_spec_map_center) && is_array($search_spec_map_center) && isset($search_spec_map_center['latitude']) ? $search_spec_map_center['latitude'] : 34.235918;
        $config['search_spec_map_center_zoom'] = isset($search_spec_map_center) && is_array($search_spec_map_center) && isset($search_spec_map_center['zoom']) ? $search_spec_map_center['zoom'] : 6;
        $config['number_of_meetings_for_auto'] = isset($number_of_meetings_for_auto) && is_numeric($number_of_meetings_for_auto) ? intval($number_of_meetings_for_auto) : 10;
        $config['auto_geocoding_enabled'] = isset($auto_geocoding_enabled) ? boolval($auto_geocoding_enabled) : true;
        $config['county_auto_geocoding_enabled'] = isset($county_auto_geocoding_enabled) ? boolval($county_auto_geocoding_enabled) : false;
        $config['zip_auto_geocoding_enabled'] = isset($zip_auto_geocoding_enabled) ? boolval($zip_auto_geocoding_enabled) : false;
        // If default_closed_status is TRUE, meetings that don't explicitly have an OPEN or CLOSED format are assumed CLOSED for the NAWS export.
        $config['default_closed_status'] = $g_defaultClosedStatus ?? true;
        $config['enable_language_selector'] = $g_enable_language_selector ?? false;
        $config['aggregator_mode_enabled'] = $aggregator_mode_enabled ?? false;
        $config['aggregator_max_geo_width_km'] = isset($aggregator_max_geo_width_km) && is_numeric($aggregator_max_geo_width_km) ? floatval($aggregator_max_geo_width_km) : 1000;
        $config['include_service_body_email_in_semantic'] = $g_include_service_body_email_in_semantic ?? false;
        $config['bmlt_title'] = $bmlt_title ?? '';
        $config['bmlt_notice'] = $bmlt_notice ?? '';
        $config['format_lang_names'] = $format_lang_names ?? [];

        self::$config = $config;
        self::$configLoaded = true;
    }
}
